﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.Context.Interface;
using VA.PPMS.IWS.MappingService.Helpers;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService.Mappers
{
    public class MapMedicalEducationToCrm : MapperRelatedBase
    {
        public MapMedicalEducationToCrm(IPpmsContextHelper ppmsContextHelper, IPpmsHelper ppmsHelper)
            : base(ppmsContextHelper, ppmsHelper)
        {}

        public async Task<ppms_medicaleducation> MapInsert(MedicalEducation education, Account provider)
        {
            // map entity
            var entity = new ppms_medicaleducation
            {
                Id = Guid.NewGuid(),
                ppms_name = education.Name
            };

            if (education.GraduationDateSpecified && education.GraduationDate.Year > EnumHelper.MinYear) entity.ppms_graduationdate = education.GraduationDate;

            // Set owner to CCN
            if (!ForVaNetwork && Owner != null) entity.OwnerId = Owner;

            await Task.Run(() => {});

            return entity;
        }

        public async Task<ppms_medicaleducation> MapUpdate(MedicalEducation entity, Account provider)
        {
            // get entity
            var crmEntity = GetCrmEntity(provider, entity.Name);

            // matching account not found
            if (crmEntity == null)
            {
                return await MapInsert(entity, provider);
            }

            var newEntity = new ppms_medicaleducation()
            {
                Id = crmEntity.Id,
                ppms_name = crmEntity.ppms_name,
                ppms_graduationdate = crmEntity.ppms_graduationdate
            };

            // Map fields
            if (entity.GraduationDateSpecified && entity.GraduationDate.Year > EnumHelper.MinYear) newEntity.ppms_graduationdate = entity.GraduationDate;

            // Set owner to CCN
            if (!ForVaNetwork && Owner != null) newEntity.OwnerId = Owner;

            return newEntity;
        }

        private static ppms_medicaleducation GetCrmEntity(Account provider, string id)
        {
            var list = provider.ppms_account_ppms_medicaleducation;
            if (list == null) return null;

            var ppmsMedicaleducations = list as ppms_medicaleducation[] ?? list.ToArray();

            return ppmsMedicaleducations.Any() ? ppmsMedicaleducations.FirstOrDefault(x => x.ppms_name == id) : null;
        }

        private static MedicalEducation ConvertEntity<T>(T entity)
        {
            return (MedicalEducation)Convert.ChangeType(entity, typeof(MedicalEducation));
        }

        public override async Task<Entity> MapUpdate<T>(T entity, Entity parent)
        {
            return await MapUpdate(ConvertEntity(entity), (Account)parent);
        }

        public override async Task<Entity> MapInsert<T>(T entity, Entity parent)
        {
            return await MapInsert(ConvertEntity(entity), (Account)parent);
        }

        public override void AddChildrenToProvider(IList<Entity> entities, Entity parent)
        {
            if (IsWithinContext) AssociateRelatedEntities(parent, entities, "ppms_account_ppms_medicaleducation");
            else
            {
                if (entities != null && entities.Count > 0)
                {
                    var account = (Account)parent;
                    if (account != null) account.ppms_account_ppms_medicaleducation = ConvertEntityList<ppms_medicaleducation>(entities);
                }
            }
        }

        public override IEnumerable<SetStateRequest> MapDelete<T>(IList<T> entities, Entity parent)
        {
            if (entities == null || !entities.Any()) return null;

            // Check provider
            var provider = (Account)parent;
            if (provider == null) return null;

            var list = new List<T>();

            // Map schema entities for delete
            foreach (var item in entities)
            {
                var entity = ConvertEntity(item);
                var entity1 = entity;
                var matches = provider.ppms_account_ppms_medicaleducation.Where(p => p.ppms_name == entity1.Name);
                list.AddRange((IEnumerable<T>)matches);
            }

            return EntityDelete((IEnumerable<ppms_medicaleducation>)list);
        }
    }
}